
#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include <mysql.h>

//#include <windows.h>
//#include <ostream.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

#define BDBLEN 40960
char qry[BDBLEN];

class BOLTdbVars {
public:
		MYSQL *sql;

};

long qryCnt=0;
long freeCnt=0;
long allocCnt=0;
long afreeCnt=0;
		BOLTdb::BOLTdb(const char *host,const char *db,
			const char *user,const char *pass,unsigned int port)
{
	tRes=NULL;
	this->vars = new BOLTdbVars();
	vars->sql=mysql_init(NULL);
	this->tRes=NULL;

#ifdef __WXDEBUG__
//	mysql_debug("d:t:g:n:S:O,/BOLT.trace");
#endif

	if (mysql_real_connect(vars->sql,host,user,pass,db,port,NULL,0))
	{

		connected=TRUE;

	} else {
	connected=FALSE;
	}

};

BOLTdb *createBOLTdb(const char *host,const char *db,
					 const char *user,const char *pass,
					 unsigned int port)
		{
			return (new BOLTdb(host,db,user,pass,port));
		}

void	deleteBOLTdb(BOLTdb **db)
	{
		delete *db;
		*db=NULL;
	}

BOLTdb::~BOLTdb()
	{
#ifdef __WXDEBUG__
//	mysql_dump_debug_info(vars->sql);
#endif
//	Flush();
	if (tRes!=NULL)
	{ free(tRes); tRes=NULL; afreeCnt++;}
	if (vars->sql) 
	{ mysql_close(vars->sql);}
	delete vars;
	}

bool BOLTdb::IsError()
	{
	return mysql_errno(vars->sql)!=0;
	}

char * BOLTdb::GetError()
	{
		return mysql_error(vars->sql);
	}
	
bool BOLTdb::Connected()
	{
	return ((connected)&&(mysql_ping(vars->sql)==0));
	}

RECORD_ID	BOLTdb::NewRecord(const char *table)
	{

	RECORD_ID tId;
	sprintf(qry,"insert into %s(ID) values(0)",table);
	mysql_real_query(vars->sql,qry,strlen(qry));
	mysql_free_result(mysql_store_result(vars->sql));
	tId=(RECORD_ID)mysql_insert_id(vars->sql);
	if (tId>0)
	{SetValue((char *)table,"created",tId,"now()");}
	return (tId);
	};


RECORD_ID	BOLTdb::NewRecord(const char *table,RECORD_ID id)
	{
	sprintf(qry,"insert into %s(ID) values(%u)",table,id);
	mysql_real_query(vars->sql,qry,strlen(qry));
	mysql_free_result(mysql_store_result(vars->sql));
	SetValue((char *)table,"created",id,"now()");
	return (id);
	};

char *	BOLTdb::GetValue(const char *table,const char *field,
				unsigned long recordID)
	{
	char *ret;
	sprintf(qry,"select %s from %s where ID=%u",field,table,recordID);
	ret=GetQueryValue(qry);
	return(ret); 
	};

double BOLTdb::GetFValue(const char *table,const char *field,
				unsigned long recordID)
	{
	sprintf(qry,"select %s from %s where ID=%u",field,table,recordID);
	char *tmp;
	if (tmp=GetQueryValue(qry))
	{ 
		if (strcmp(tmp,"NULL")==0)
		{ return 0; }
		return atof(tmp); 
	}
	return(0); 
	};

long BOLTdb::GetIValue(const char *table,const char *field,
				unsigned long recordID)
	{
	sprintf(qry,"select %s from %s where ID=%u",field,table,recordID);
	char *tmp;
	if (tmp=GetQueryValue(qry))
	{ 
		if (strcmp(tmp,"NULL")==0)
		{ return 0; }
		return atoi(tmp); 
	}
	return(0); 
	};

RECORD_ID BOLTdb::GetUValue(const char *table, const char *field, RECORD_ID recordID)
{
	sprintf(qry,"select %s from %s where ID=%u",field,table,recordID);
	char *tmp;
	if (tmp=GetQueryValue(qry))
	{ 
		if (strcmp(tmp,"NULL")==0)
		{ return 0; }
		return atol(tmp); 
	}
	return(0); 
}

char *	BOLTdb::GetQueryValue(const char *qry)
	{
	MYSQL_RES *res;
	MYSQL_ROW row;
	unsigned long *lengths;
	if (qry==tRes) { LOG_ERROR("Programmer Error - Reusing Memory Badly"); }
	mysql_real_query(vars->sql,qry,strlen(qry));

	if ((res=mysql_store_result(vars->sql))==NULL)
	{
		mysql_free_result(res);
		return NULL;
	}

	if ((row=mysql_fetch_row(res))==NULL)
	{ 
		mysql_free_result(res);
		return NULL;
	}
	lengths=mysql_fetch_lengths(res);
	if (tRes!=NULL)
	{ free(tRes); tRes=NULL; afreeCnt++;}
	if ((row[0])&&(lengths[0]!=0))
	{
		tRes = (char *)malloc(lengths[0]+1);	allocCnt++;
		memcpy(tRes,row[0],lengths[0]);
		tRes[lengths[0]]=0;
	}
	mysql_free_result(res);
	return(tRes);	
};

char *BOLTdb::EscapeString(const char* str)
{
	long length;
	length=strlen(str);
	if (str==tRes) { LOG_ERROR("Programmer Error - Reusing Memory Badly"); }
	if (tRes!=NULL)
	{ free(tRes); tRes=NULL; afreeCnt++;}
	tRes = (char *)malloc(length*2+1);
		allocCnt++;
	mysql_real_escape_string(vars->sql,tRes,str,length);
//	tRes[length+1]='\0';
	return(tRes);	
}

bool	BOLTdb::SetValue(const char *table,const char *field,
				 RECORD_ID recordID,const char *value)
{
	char *qry;
	char fstr[]="update %s set %s=%s where ID=%u";
	unsigned long size;
	if (value==NULL)
	{
	size=strlen(fstr)+strlen(table)+strlen(field)+1+24+4;
	qry=(char *)malloc(size);
	sprintf(qry,"update %s set %s=NULL where ID=%u",table,field,recordID);
	}
	else
	{
	size=strlen(fstr)+strlen(table)+strlen(field)+strlen(value)+1+24;
	qry=(char *)malloc(size);
	sprintf(qry,"update %s set %s=%s where ID=%u",table,field,value,recordID);
	}
	mysql_real_query(vars->sql,qry,size);
	mysql_free_result(mysql_store_result(vars->sql)); 
	free(qry); 
	return true;
};

bool	BOLTdb::SetBinaryValue(const char *table,const char *field,
				 RECORD_ID recordID,const char *value,unsigned long size)
{

	char *eBuffer,*tBuffer=NULL,*nBuffer=NULL;
	char junk[32];
	int l,t;
	l=0;
	eBuffer=(char *)malloc(size*2+1);


#define dAdd(data) t=strlen(data); \
	nBuffer=(char *)malloc(l+t); \
	if (tBuffer) { \
	 memcpy(nBuffer,tBuffer,l); \
	 free(tBuffer); afreeCnt++;}\
	tBuffer=nBuffer;  \
	memcpy(&(tBuffer[l]),data,t); l+=t;

//	tBuffer=NULL;
	dAdd("update ");
	dAdd(table);
	dAdd(" set ");
	dAdd(field);
	dAdd("='");

	t=mysql_real_escape_string(vars->sql,eBuffer,value,size);
	nBuffer=(char *)malloc(l+t);   
	if (tBuffer) {  
		memcpy(nBuffer,tBuffer,l);  
		free(tBuffer); } 
	tBuffer=nBuffer;   
	memcpy(&(tBuffer[l]),eBuffer,t); 
	l+=t;

	dAdd("' where id=");
	sprintf(junk,"%u",recordID);
	dAdd(junk);
	mysql_real_query(vars->sql,tBuffer,l);
	mysql_free_result(mysql_store_result(vars->sql));
	free(eBuffer); 
	free(tBuffer); 
	return true;
};

bool	BOLTdb::SetValue(const char *table,const char *field,
				 RECORD_ID recordID,double value)
{
//	char qry[BDBLEN];
	sprintf(qry,"update %s set %s=%f where ID=%u",table,field,value,recordID);
//	mysql_real_escape_string(vars->sql,qry2,qry,strlen(qry));
/*	if (*/mysql_real_query(vars->sql,qry,strlen(qry));/*)*/
//	{ return NULL; }
	mysql_free_result(mysql_store_result(vars->sql));
	return true;
};

bool	BOLTdb::SetValue(const char *table,const char *field,
				 RECORD_ID recordID,RECORD_ID value)
{
//	char qry[BDBLEN];
	sprintf(qry,"update %s set %s=%u where ID=%u",table,field,value,recordID);
//	mysql_real_escape_string(vars->sql,qry2,qry,strlen(qry));
/*	if (*/mysql_real_query(vars->sql,qry,strlen(qry));/*)*/
//	{ return NULL; }
	mysql_free_result(mysql_store_result(vars->sql));
	return true;
};

QRY_ID	BOLTdb::Query(const char *qry,long length)
{
	//int mysql_real_query(MYSQL *mysql, const char *query, unsigned int length) 
QRY_ID retQry;	

		if (mysql_real_query(vars->sql,qry,length)==0)
		{
			retQry=(QRY_ID)mysql_store_result(vars->sql);
			if (retQry)
			{
			qryCnt++;
			} else { mysql_free_result((MYSQL_RES *)retQry);};
			return retQry;
		}
		else {
			//mysql_store_result(vars->sql);
			return (QRY_ID)NULL;
		}
};

char *	BOLTdb::FetchQueryResult(QRY_ID qry,void *row,int field)
{	unsigned long *lengths;
	lengths=mysql_fetch_lengths((MYSQL_RES *)qry);
	if (lengths[field]>0)
	{
		return ((MYSQL_ROW)row)[field];
	} else { return NULL; }
};

void *	BOLTdb::FetchRow(QRY_ID qry)
{
	return (void *)mysql_fetch_row((MYSQL_RES *)qry); 
};

void BOLTdb::FreeQuery(QRY_ID qry)
{
	if (qry!=NULL) {
		mysql_free_result((MYSQL_RES *)qry);
		freeCnt++;
		qryCnt--;
//		if (freeCnt < qryCnt - 7)
//		{ wxMessageBox("HELP"); }
	}
}

void BOLTdb::GetBinaryQueryValue(const char *qry,void **ptr, unsigned long &length)
{
	MYSQL_RES *res;
	MYSQL_ROW row;
	unsigned long *lengths;

	*ptr=NULL;
	length=0;
/*	if (*/mysql_real_query(vars->sql,qry,strlen(qry));/*)*/
//	{ return NULL; }
	if ((res=mysql_store_result(vars->sql))==NULL)
		return;
	if ((row=mysql_fetch_row(res))==NULL)
	{ 
		mysql_free_result(res);
		return;
	}
	lengths=mysql_fetch_lengths(res);
	if ((row[0])&&(lengths[0]!=0))
	{
		length=lengths[0];
		*ptr = (void *)malloc(length);
		memcpy(*ptr,row[0],length);
	}
	mysql_free_result(res);
}

unsigned int BOLTdb::FetchNumCols(QRY_ID qry, void *row)
{
 return mysql_num_fields((MYSQL_RES *)qry);
}
unsigned long BOLTdb::FetchNumRows(QRY_ID qry)
{
 return (unsigned long)mysql_num_rows((MYSQL_RES *)qry);
}

void BOLTdb::FetchBinaryResults(QRY_ID qry,const void *row, int field, void **ptr, unsigned long * size)
{
	unsigned long *lengths;

	*ptr=NULL;
	*size=0;

	lengths=mysql_fetch_lengths((MYSQL_RES *)qry);
	if ((((MYSQL_ROW)row)[field])&&(lengths[field]!=0))
	{
		*size=lengths[field];
		*ptr = (void *)malloc(*size); 
		if (*ptr!=NULL)
		{ memcpy(*ptr,((MYSQL_ROW)row)[field],*size); }
	}
}

void BOLTdb::Flush()
{
	FreeQuery(Query("FLUSH TABLES",13));
}

void BOLTdb::freePtr(void **ptr)
{
	if (ptr)
	{ if (*ptr) {
	free(*ptr); afreeCnt++;
	*ptr=NULL;
	} }
}


